# Generated by ariadne-codegen
# Source: tools/graphql_codegen/artifacts/

__all__ = [
    "ADD_ALIASES_GQL",
    "ARTIFACT_BY_ID_GQL",
    "ARTIFACT_BY_NAME_GQL",
    "ARTIFACT_COLLECTION_MEMBERSHIP_FILES_GQL",
    "ARTIFACT_COLLECTION_MEMBERSHIP_FILE_URLS_GQL",
    "ARTIFACT_CREATED_BY_GQL",
    "ARTIFACT_FILE_URLS_GQL",
    "ARTIFACT_TYPE_GQL",
    "ARTIFACT_USED_BY_GQL",
    "ARTIFACT_VERSION_FILES_GQL",
    "ARTIFACT_VIA_MEMBERSHIP_BY_NAME_GQL",
    "CREATE_ARTIFACT_COLLECTION_TAG_ASSIGNMENTS_GQL",
    "DELETE_ALIASES_GQL",
    "DELETE_ARTIFACT_COLLECTION_TAG_ASSIGNMENTS_GQL",
    "DELETE_ARTIFACT_GQL",
    "DELETE_ARTIFACT_PORTFOLIO_GQL",
    "DELETE_ARTIFACT_SEQUENCE_GQL",
    "FETCH_ARTIFACT_MANIFEST_GQL",
    "FETCH_LINKED_ARTIFACTS_GQL",
    "FETCH_REGISTRIES_GQL",
    "LINK_ARTIFACT_GQL",
    "MOVE_ARTIFACT_COLLECTION_GQL",
    "PROJECT_ARTIFACTS_GQL",
    "PROJECT_ARTIFACT_COLLECTIONS_GQL",
    "PROJECT_ARTIFACT_COLLECTION_GQL",
    "PROJECT_ARTIFACT_TYPES_GQL",
    "PROJECT_ARTIFACT_TYPE_GQL",
    "REGISTRY_COLLECTIONS_GQL",
    "REGISTRY_VERSIONS_GQL",
    "RUN_INPUT_ARTIFACTS_GQL",
    "RUN_OUTPUT_ARTIFACTS_GQL",
    "UNLINK_ARTIFACT_GQL",
    "UPDATE_ARTIFACT_GQL",
    "UPDATE_ARTIFACT_PORTFOLIO_GQL",
    "UPDATE_ARTIFACT_SEQUENCE_GQL",
]

DELETE_ARTIFACT_SEQUENCE_GQL = """
mutation DeleteArtifactSequence($id: ID!) {
  deleteArtifactSequence(input: {artifactSequenceID: $id}) {
    artifactCollection {
      __typename
      state
    }
  }
}
"""

DELETE_ARTIFACT_PORTFOLIO_GQL = """
mutation DeleteArtifactPortfolio($id: ID!) {
  deleteArtifactPortfolio(input: {artifactPortfolioID: $id}) {
    artifactCollection {
      __typename
      state
    }
  }
}
"""

UPDATE_ARTIFACT_SEQUENCE_GQL = """
mutation UpdateArtifactSequence($id: ID!, $name: String, $description: String) {
  updateArtifactSequence(
    input: {artifactSequenceID: $id, name: $name, description: $description}
  ) {
    artifactCollection {
      __typename
      id
      name
      description
    }
  }
}
"""

UPDATE_ARTIFACT_PORTFOLIO_GQL = """
mutation UpdateArtifactPortfolio($id: ID!, $name: String, $description: String) {
  updateArtifactPortfolio(
    input: {artifactPortfolioID: $id, name: $name, description: $description}
  ) {
    artifactCollection {
      __typename
      id
      name
      description
    }
  }
}
"""

MOVE_ARTIFACT_COLLECTION_GQL = """
mutation MoveArtifactCollection($artifactSequenceID: ID!, $destinationArtifactTypeName: String!) {
  moveArtifactSequence(
    input: {artifactSequenceID: $artifactSequenceID, destinationArtifactTypeName: $destinationArtifactTypeName}
  ) {
    artifactCollection {
      __typename
      id
      name
      description
    }
  }
}
"""

CREATE_ARTIFACT_COLLECTION_TAG_ASSIGNMENTS_GQL = """
mutation CreateArtifactCollectionTagAssignments($entityName: String!, $projectName: String!, $artifactCollectionName: String!, $tags: [TagInput!]!) {
  createArtifactCollectionTagAssignments(
    input: {entityName: $entityName, projectName: $projectName, artifactCollectionName: $artifactCollectionName, tags: $tags}
  ) {
    tags {
      id
      name
      tagCategoryName
    }
  }
}
"""

DELETE_ARTIFACT_COLLECTION_TAG_ASSIGNMENTS_GQL = """
mutation DeleteArtifactCollectionTagAssignments($entityName: String!, $projectName: String!, $artifactCollectionName: String!, $tags: [TagInput!]!) {
  deleteArtifactCollectionTagAssignments(
    input: {entityName: $entityName, projectName: $projectName, artifactCollectionName: $artifactCollectionName, tags: $tags}
  ) {
    success
  }
}
"""

PROJECT_ARTIFACT_COLLECTIONS_GQL = """
query ProjectArtifactCollections($entityName: String!, $projectName: String!, $artifactTypeName: String!, $cursor: String) {
  project(name: $projectName, entityName: $entityName) {
    artifactType(name: $artifactTypeName) {
      artifactCollections: artifactCollections(after: $cursor) {
        ...ArtifactCollectionsFragment
      }
    }
  }
}

fragment ArtifactCollectionsFragment on ArtifactCollectionConnection {
  pageInfo {
    endCursor
    hasNextPage
  }
  totalCount
  edges {
    node {
      __typename
      id
      name
      description
      createdAt
    }
    cursor
  }
}
"""

PROJECT_ARTIFACT_COLLECTION_GQL = """
query ProjectArtifactCollection($entityName: String!, $projectName: String!, $artifactTypeName: String!, $artifactCollectionName: String!, $cursor: String, $perPage: Int = 1000) {
  project(name: $projectName, entityName: $entityName) {
    artifactType(name: $artifactTypeName) {
      artifactCollection: artifactCollection(name: $artifactCollectionName) {
        __typename
        id
        name
        description
        createdAt
        tags {
          edges {
            node {
              id
              name
            }
          }
        }
        aliases(after: $cursor, first: $perPage) {
          edges {
            node {
              alias
            }
            cursor
          }
          pageInfo {
            endCursor
            hasNextPage
          }
        }
      }
      artifactSequence(name: $artifactCollectionName) {
        __typename
      }
    }
  }
}
"""

ARTIFACT_VERSION_FILES_GQL = """
query ArtifactVersionFiles($entityName: String!, $projectName: String!, $artifactTypeName: String!, $artifactName: String!, $fileNames: [String!], $fileCursor: String, $fileLimit: Int = 50) {
  project(name: $projectName, entityName: $entityName) {
    artifactType(name: $artifactTypeName) {
      artifact(name: $artifactName) {
        files(names: $fileNames, after: $fileCursor, first: $fileLimit) {
          ...FilesFragment
        }
      }
    }
  }
}

fragment FilesFragment on FileConnection {
  edges {
    node {
      id
      name: displayName
      url
      sizeBytes
      storagePath @include(if: true)
      mimetype
      updatedAt
      digest
      md5
      directUrl
    }
    cursor
  }
  pageInfo {
    endCursor
    hasNextPage
  }
}
"""

ARTIFACT_COLLECTION_MEMBERSHIP_FILES_GQL = """
query ArtifactCollectionMembershipFiles($entityName: String!, $projectName: String!, $artifactName: String!, $artifactVersionIndex: String!, $fileNames: [String!], $fileCursor: String, $fileLimit: Int = 50) {
  project(name: $projectName, entityName: $entityName) {
    artifactCollection(name: $artifactName) {
      __typename
      artifactMembership(aliasName: $artifactVersionIndex) {
        files(names: $fileNames, after: $fileCursor, first: $fileLimit) {
          ...FilesFragment
        }
      }
    }
  }
}

fragment FilesFragment on FileConnection {
  edges {
    node {
      id
      name: displayName
      url
      sizeBytes
      storagePath @include(if: true)
      mimetype
      updatedAt
      digest
      md5
      directUrl
    }
    cursor
  }
  pageInfo {
    endCursor
    hasNextPage
  }
}
"""

ARTIFACT_COLLECTION_MEMBERSHIP_FILE_URLS_GQL = """
query ArtifactCollectionMembershipFileUrls($entityName: String!, $projectName: String!, $artifactName: String!, $artifactVersionIndex: String!, $cursor: String, $perPage: Int) {
  project(name: $projectName, entityName: $entityName) {
    artifactCollection(name: $artifactName) {
      __typename
      artifactMembership(aliasName: $artifactVersionIndex) {
        files(after: $cursor, first: $perPage) {
          ...FileUrlsFragment
        }
      }
    }
  }
}

fragment FileUrlsFragment on FileConnection {
  pageInfo {
    hasNextPage
    endCursor
  }
  edges {
    node {
      name
      directUrl
    }
  }
}
"""

ARTIFACT_FILE_URLS_GQL = """
query ArtifactFileUrls($id: ID!, $cursor: String, $perPage: Int) {
  artifact(id: $id) {
    files(after: $cursor, first: $perPage) {
      ...FileUrlsFragment
    }
  }
}

fragment FileUrlsFragment on FileConnection {
  pageInfo {
    hasNextPage
    endCursor
  }
  edges {
    node {
      name
      directUrl
    }
  }
}
"""

PROJECT_ARTIFACT_TYPES_GQL = """
query ProjectArtifactTypes($entityName: String!, $projectName: String!, $cursor: String) {
  project(name: $projectName, entityName: $entityName) {
    artifactTypes(after: $cursor) {
      ...ArtifactTypesFragment
    }
  }
}

fragment ArtifactTypeFragment on ArtifactType {
  __typename
  id
  name
  description
  createdAt
}

fragment ArtifactTypesFragment on ArtifactTypeConnection {
  edges {
    node {
      ...ArtifactTypeFragment
    }
    cursor
  }
  pageInfo {
    endCursor
    hasNextPage
  }
}
"""

PROJECT_ARTIFACT_TYPE_GQL = """
query ProjectArtifactType($entityName: String!, $projectName: String!, $artifactTypeName: String!) {
  project(name: $projectName, entityName: $entityName) {
    artifactType(name: $artifactTypeName) {
      ...ArtifactTypeFragment
    }
  }
}

fragment ArtifactTypeFragment on ArtifactType {
  __typename
  id
  name
  description
  createdAt
}
"""

PROJECT_ARTIFACTS_GQL = """
query ProjectArtifacts($project: String!, $entity: String!, $type: String!, $collection: String!, $cursor: String, $perPage: Int = 50, $order: String, $filters: JSONString) {
  project(name: $project, entityName: $entity) {
    artifactType(name: $type) {
      artifactCollection: artifactCollection(name: $collection) {
        __typename
        name
        artifacts(filters: $filters, after: $cursor, first: $perPage, order: $order) {
          ...ArtifactsFragment
        }
      }
    }
  }
}

fragment ArtifactFragment on Artifact {
  ...ArtifactFragmentWithoutAliases
  aliases @include(if: true) {
    artifactCollection {
      __typename
      project {
        entityName
        name
      }
      name
    }
    alias
  }
}

fragment ArtifactFragmentWithoutAliases on Artifact {
  id
  artifactSequence {
    project {
      entityName
      name
    }
    name
  }
  versionIndex
  artifactType {
    name
  }
  description
  metadata
  ttlDurationSeconds @include(if: true)
  ttlIsInherited @include(if: true)
  tags @include(if: true) {
    name
  }
  historyStep @include(if: true)
  state
  currentManifest {
    file {
      directUrl
    }
  }
  commitHash
  fileCount
  createdAt
  updatedAt
}

fragment ArtifactsFragment on VersionedArtifactConnection {
  totalCount
  edges {
    node {
      ...ArtifactFragment
    }
    version
    cursor
  }
  pageInfo {
    endCursor
    hasNextPage
  }
}
"""

RUN_OUTPUT_ARTIFACTS_GQL = """
query RunOutputArtifacts($entity: String!, $project: String!, $runName: String!, $cursor: String, $perPage: Int) {
  project(name: $project, entityName: $entity) {
    run(name: $runName) {
      outputArtifacts(after: $cursor, first: $perPage) {
        totalCount
        edges {
          node {
            ...ArtifactFragment
          }
          cursor
        }
        pageInfo {
          endCursor
          hasNextPage
        }
      }
    }
  }
}

fragment ArtifactFragment on Artifact {
  ...ArtifactFragmentWithoutAliases
  aliases @include(if: true) {
    artifactCollection {
      __typename
      project {
        entityName
        name
      }
      name
    }
    alias
  }
}

fragment ArtifactFragmentWithoutAliases on Artifact {
  id
  artifactSequence {
    project {
      entityName
      name
    }
    name
  }
  versionIndex
  artifactType {
    name
  }
  description
  metadata
  ttlDurationSeconds @include(if: true)
  ttlIsInherited @include(if: true)
  tags @include(if: true) {
    name
  }
  historyStep @include(if: true)
  state
  currentManifest {
    file {
      directUrl
    }
  }
  commitHash
  fileCount
  createdAt
  updatedAt
}
"""

RUN_INPUT_ARTIFACTS_GQL = """
query RunInputArtifacts($entity: String!, $project: String!, $runName: String!, $cursor: String, $perPage: Int) {
  project(name: $project, entityName: $entity) {
    run(name: $runName) {
      inputArtifacts(after: $cursor, first: $perPage) {
        totalCount
        edges {
          node {
            ...ArtifactFragment
          }
          cursor
        }
        pageInfo {
          endCursor
          hasNextPage
        }
      }
    }
  }
}

fragment ArtifactFragment on Artifact {
  ...ArtifactFragmentWithoutAliases
  aliases @include(if: true) {
    artifactCollection {
      __typename
      project {
        entityName
        name
      }
      name
    }
    alias
  }
}

fragment ArtifactFragmentWithoutAliases on Artifact {
  id
  artifactSequence {
    project {
      entityName
      name
    }
    name
  }
  versionIndex
  artifactType {
    name
  }
  description
  metadata
  ttlDurationSeconds @include(if: true)
  ttlIsInherited @include(if: true)
  tags @include(if: true) {
    name
  }
  historyStep @include(if: true)
  state
  currentManifest {
    file {
      directUrl
    }
  }
  commitHash
  fileCount
  createdAt
  updatedAt
}
"""

FETCH_LINKED_ARTIFACTS_GQL = """
query FetchLinkedArtifacts($artifactID: ID!) {
  artifact(id: $artifactID) {
    artifactMemberships {
      edges {
        node {
          aliases {
            alias
          }
          versionIndex
          artifactCollection {
            project {
              entityName
              name
            }
            name
            __typename
          }
        }
      }
    }
  }
}
"""

FETCH_ARTIFACT_MANIFEST_GQL = """
query FetchArtifactManifest($entityName: String!, $projectName: String!, $name: String!) {
  project(entityName: $entityName, name: $projectName) {
    artifact(name: $name) {
      currentManifest {
        file {
          directUrl
        }
      }
    }
  }
}
"""

ARTIFACT_BY_ID_GQL = """
query ArtifactByID($id: ID!) {
  artifact(id: $id) {
    ...ArtifactFragment
  }
}

fragment ArtifactFragment on Artifact {
  ...ArtifactFragmentWithoutAliases
  aliases @include(if: true) {
    artifactCollection {
      __typename
      project {
        entityName
        name
      }
      name
    }
    alias
  }
}

fragment ArtifactFragmentWithoutAliases on Artifact {
  id
  artifactSequence {
    project {
      entityName
      name
    }
    name
  }
  versionIndex
  artifactType {
    name
  }
  description
  metadata
  ttlDurationSeconds @include(if: true)
  ttlIsInherited @include(if: true)
  tags @include(if: true) {
    name
  }
  historyStep @include(if: true)
  state
  currentManifest {
    file {
      directUrl
    }
  }
  commitHash
  fileCount
  createdAt
  updatedAt
}
"""

ARTIFACT_BY_NAME_GQL = """
query ArtifactByName($entityName: String!, $projectName: String!, $name: String!, $enableTracking: Boolean) {
  project(name: $projectName, entityName: $entityName) {
    artifact(name: $name, enableTracking: $enableTracking) {
      ...ArtifactFragment
    }
  }
}

fragment ArtifactFragment on Artifact {
  ...ArtifactFragmentWithoutAliases
  aliases @include(if: true) {
    artifactCollection {
      __typename
      project {
        entityName
        name
      }
      name
    }
    alias
  }
}

fragment ArtifactFragmentWithoutAliases on Artifact {
  id
  artifactSequence {
    project {
      entityName
      name
    }
    name
  }
  versionIndex
  artifactType {
    name
  }
  description
  metadata
  ttlDurationSeconds @include(if: true)
  ttlIsInherited @include(if: true)
  tags @include(if: true) {
    name
  }
  historyStep @include(if: true)
  state
  currentManifest {
    file {
      directUrl
    }
  }
  commitHash
  fileCount
  createdAt
  updatedAt
}
"""

ARTIFACT_VIA_MEMBERSHIP_BY_NAME_GQL = """
query ArtifactViaMembershipByName($entityName: String!, $projectName: String!, $name: String!) {
  project(name: $projectName, entityName: $entityName) {
    artifactCollectionMembership(name: $name) {
      ...MembershipWithArtifact
    }
  }
}

fragment ArtifactFragment on Artifact {
  ...ArtifactFragmentWithoutAliases
  aliases @include(if: true) {
    artifactCollection {
      __typename
      project {
        entityName
        name
      }
      name
    }
    alias
  }
}

fragment ArtifactFragmentWithoutAliases on Artifact {
  id
  artifactSequence {
    project {
      entityName
      name
    }
    name
  }
  versionIndex
  artifactType {
    name
  }
  description
  metadata
  ttlDurationSeconds @include(if: true)
  ttlIsInherited @include(if: true)
  tags @include(if: true) {
    name
  }
  historyStep @include(if: true)
  state
  currentManifest {
    file {
      directUrl
    }
  }
  commitHash
  fileCount
  createdAt
  updatedAt
}

fragment MembershipWithArtifact on ArtifactCollectionMembership {
  id
  artifactCollection {
    __typename
    id
    name
    project {
      id
      entityName
      name
    }
  }
  artifact {
    ...ArtifactFragment
  }
}
"""

ARTIFACT_USED_BY_GQL = """
query ArtifactUsedBy($id: ID!) {
  artifact(id: $id) {
    usedBy {
      edges {
        node {
          name
          project {
            name
            entityName
          }
        }
      }
    }
  }
}
"""

ARTIFACT_CREATED_BY_GQL = """
query ArtifactCreatedBy($id: ID!) {
  artifact(id: $id) {
    createdBy {
      __typename
      ... on Run {
        name
        project {
          name
          entityName
        }
      }
    }
  }
}
"""

ARTIFACT_TYPE_GQL = """
query ArtifactType($entityName: String, $projectName: String, $name: String!) {
  project(name: $projectName, entityName: $entityName) {
    artifact(name: $name) {
      artifactType {
        name
      }
    }
  }
}
"""

ADD_ALIASES_GQL = """
mutation AddAliases($artifactID: ID!, $aliases: [ArtifactCollectionAliasInput!]!) {
  addAliases(input: {artifactID: $artifactID, aliases: $aliases}) {
    success
  }
}
"""

DELETE_ALIASES_GQL = """
mutation DeleteAliases($artifactID: ID!, $aliases: [ArtifactCollectionAliasInput!]!) {
  deleteAliases(input: {artifactID: $artifactID, aliases: $aliases}) {
    success
  }
}
"""

UPDATE_ARTIFACT_GQL = """
mutation UpdateArtifact($artifactID: ID!, $description: String, $metadata: JSONString, $ttlDurationSeconds: Int64, $tagsToAdd: [TagInput!], $tagsToDelete: [TagInput!], $aliases: [ArtifactAliasInput!]) {
  updateArtifact(
    input: {artifactID: $artifactID, description: $description, metadata: $metadata, ttlDurationSeconds: $ttlDurationSeconds, tagsToAdd: $tagsToAdd, tagsToDelete: $tagsToDelete, aliases: $aliases}
  ) {
    artifact {
      ...ArtifactFragment
    }
  }
}

fragment ArtifactFragment on Artifact {
  ...ArtifactFragmentWithoutAliases
  aliases @include(if: true) {
    artifactCollection {
      __typename
      project {
        entityName
        name
      }
      name
    }
    alias
  }
}

fragment ArtifactFragmentWithoutAliases on Artifact {
  id
  artifactSequence {
    project {
      entityName
      name
    }
    name
  }
  versionIndex
  artifactType {
    name
  }
  description
  metadata
  ttlDurationSeconds @include(if: true)
  ttlIsInherited @include(if: true)
  tags @include(if: true) {
    name
  }
  historyStep @include(if: true)
  state
  currentManifest {
    file {
      directUrl
    }
  }
  commitHash
  fileCount
  createdAt
  updatedAt
}
"""

DELETE_ARTIFACT_GQL = """
mutation DeleteArtifact($artifactID: ID!, $deleteAliases: Boolean) {
  deleteArtifact(input: {artifactID: $artifactID, deleteAliases: $deleteAliases}) {
    artifact {
      id
    }
  }
}
"""

LINK_ARTIFACT_GQL = """
mutation LinkArtifact($input: LinkArtifactInput!) {
  linkArtifact(input: $input) {
    versionIndex
    artifactMembership @include(if: true) {
      ...MembershipWithArtifact
    }
  }
}

fragment ArtifactFragment on Artifact {
  ...ArtifactFragmentWithoutAliases
  aliases @include(if: true) {
    artifactCollection {
      __typename
      project {
        entityName
        name
      }
      name
    }
    alias
  }
}

fragment ArtifactFragmentWithoutAliases on Artifact {
  id
  artifactSequence {
    project {
      entityName
      name
    }
    name
  }
  versionIndex
  artifactType {
    name
  }
  description
  metadata
  ttlDurationSeconds @include(if: true)
  ttlIsInherited @include(if: true)
  tags @include(if: true) {
    name
  }
  historyStep @include(if: true)
  state
  currentManifest {
    file {
      directUrl
    }
  }
  commitHash
  fileCount
  createdAt
  updatedAt
}

fragment MembershipWithArtifact on ArtifactCollectionMembership {
  id
  artifactCollection {
    __typename
    id
    name
    project {
      id
      entityName
      name
    }
  }
  artifact {
    ...ArtifactFragment
  }
}
"""

UNLINK_ARTIFACT_GQL = """
mutation UnlinkArtifact($artifactID: ID!, $artifactPortfolioID: ID!) {
  unlinkArtifact(
    input: {artifactID: $artifactID, artifactPortfolioID: $artifactPortfolioID}
  ) {
    artifactID
    success
    clientMutationId
  }
}
"""

REGISTRY_VERSIONS_GQL = """
query RegistryVersions($organization: String!, $registryFilter: JSONString, $collectionFilter: JSONString, $artifactFilter: JSONString, $cursor: String, $perPage: Int) {
  organization(name: $organization) {
    orgEntity {
      name
      artifactMemberships(
        projectFilters: $registryFilter
        collectionFilters: $collectionFilter
        filters: $artifactFilter
        after: $cursor
        first: $perPage
      ) {
        ...RegistryVersionsPage
      }
    }
  }
}

fragment ArtifactFragmentWithoutAliases on Artifact {
  id
  artifactSequence {
    project {
      entityName
      name
    }
    name
  }
  versionIndex
  artifactType {
    name
  }
  description
  metadata
  ttlDurationSeconds @include(if: true)
  ttlIsInherited @include(if: true)
  tags @include(if: true) {
    name
  }
  historyStep @include(if: true)
  state
  currentManifest {
    file {
      directUrl
    }
  }
  commitHash
  fileCount
  createdAt
  updatedAt
}

fragment RegistryVersionsPage on ArtifactCollectionMembershipConnection {
  pageInfo {
    endCursor
    hasNextPage
  }
  edges {
    node {
      artifactCollection {
        __typename
        project {
          name
          entity {
            name
          }
        }
        name
      }
      versionIndex
      artifact {
        ...ArtifactFragmentWithoutAliases
      }
      aliases {
        alias
      }
    }
  }
}
"""

REGISTRY_COLLECTIONS_GQL = """
query RegistryCollections($organization: String!, $registryFilter: JSONString, $collectionFilter: JSONString, $collectionTypes: [ArtifactCollectionType!], $cursor: String, $perPage: Int) {
  organization(name: $organization) {
    orgEntity {
      name
      artifactCollections(
        projectFilters: $registryFilter
        filters: $collectionFilter
        collectionTypes: $collectionTypes
        after: $cursor
        first: $perPage
      ) {
        ...RegistryCollectionsPage
      }
    }
  }
}

fragment RegistryCollectionsPage on ArtifactCollectionConnection {
  totalCount
  pageInfo {
    endCursor
    hasNextPage
  }
  edges {
    cursor
    node {
      __typename
      id
      name
      description
      createdAt
      tags {
        edges {
          node {
            name
          }
        }
      }
      project {
        name
        entity {
          name
        }
      }
      defaultArtifactType {
        name
      }
      aliases {
        edges {
          node {
            alias
          }
        }
      }
    }
  }
}
"""

FETCH_REGISTRIES_GQL = """
query FetchRegistries($organization: String!, $filters: JSONString, $cursor: String, $perPage: Int) {
  organization(name: $organization) {
    orgEntity {
      name
      projects(filters: $filters, after: $cursor, first: $perPage) {
        ...RegistriesPage
      }
    }
  }
}

fragment RegistriesPage on ProjectConnection {
  pageInfo {
    endCursor
    hasNextPage
  }
  edges {
    node {
      ...RegistryFragment
    }
  }
}

fragment RegistryFragment on Project {
  id
  allowAllArtifactTypesInRegistry
  artifactTypes(includeAll: true) {
    edges {
      node {
        name
      }
    }
  }
  name
  description
  createdAt
  updatedAt
  access
}
"""
