#include "mainwindow.h"

#include <QApplication>
#include <QScreen>

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);

    QString wallpaperFile;

    if (argc > 1) {
        wallpaperFile = QString(argv[1]);
    } else {
        return 1;
    }

    for (QScreen *screen : QApplication::screens()) {
        MainWindow *w = new MainWindow(wallpaperFile);
        // 设置窗口标志：无边框、置于底层、工具窗口
        w->setWindowFlags(Qt::FramelessWindowHint |
                         Qt::WindowStaysOnBottomHint |
                         Qt::Tool |
                         Qt::WindowDoesNotAcceptFocus);
        // 设置窗口属性：不在任务栏显示
        w->setAttribute(Qt::WA_ShowWithoutActivating);
        w->setGeometry(screen->geometry());
        w->showFullScreen();
        w->show();
        w->applyWallpaper();
    }

    return a.exec();
}
