import os
import time

from functions import func_map

from llm import LLMModel, FCModel
llm_model = LLMModel()
fc_model = FCModel()

from asr import ASRModel, RecAudio
asr_model = ASRModel()
rec_audio = RecAudio()

if __name__ == '__main__':
    try:
        while True:
            print("Press enter to start!")
            input() # enter 触发
            audio_file = rec_audio.record_audio()
            text = asr_model.generate(audio_file)
            print('user: ', text)

            t1 = time.time()
            function_called = fc_model.func_response(text, func_map)
            print('used time:', time.time() - t1)
            if function_called:
                continue

            llm_output = llm_model.generate(text)
            for output_text in llm_output:
                print(output_text, end='', flush=True)

    except KeyboardInterrupt:
        print("process was interrupted by user.")
