#ifndef DUERUVOICE_VOICEPRINT_SDK_DEF_H
#define DUERUVOICE_VOICEPRINT_SDK_DEF_H

// Role registered voice files and model store in these dirs

#define MAX_PATH_STR_LEN 256

typedef struct struct_vp_setting{
    char training_role1_dir[MAX_PATH_STR_LEN];
    char training_role2_dir[MAX_PATH_STR_LEN];
    char training_role3_dir[MAX_PATH_STR_LEN];
    char training_role4_dir[MAX_PATH_STR_LEN];
    char training_role5_dir[MAX_PATH_STR_LEN];
    char training_role6_dir[MAX_PATH_STR_LEN];
    char background_model_path[MAX_PATH_STR_LEN];
}uvp_config;
#define NUM_ROLE 6

typedef enum voiceprint_roles{
r_error = -2,
r_unk = -1,
r_role1 = 0,
r_role2,
r_role3,
r_role4,
r_role5,
r_role6
}uvp_roles;

typedef enum duer_voiceprint_status{
	UVP_ST_OK = 0,
	UVP_ST_ERROR,
	UVP_ST_VERIFY_OK,
	UVP_ST_VERIFY_ERROR,
	UVP_ST_REGISTER_OK,
	UVP_ST_REGISTER_ERROR,
        UVP_ST_DATA_OK,
        UVP_ST_DATA_ERROR_TOO_NOISY,
        UVP_ST_DATA_ERROR_TOO_SHORT,
        UVP_ST_DATA_ERROR_OTHERS
}uvp_status;

void* Dueruvoice_VoicePrint_Init(uvp_config* config);
const char* Dueruvoice_VoicePrint_GetVersion();

// 本函数用来检查注册和验证的语音质量是否正常
uvp_status Dueruvoice_VoicePrint_CheckData(void* handle,short* audio_buf, int buf_len);

// 本函数用于特定用户的音频注册，role_id为用户id，目前有效范围为0-5
uvp_status Dueruvoice_VoicePrint_Register(void* handle, uvp_roles role);

// 本函数完成验证前的一部分初始化工作
uvp_status Dueruvoice_VoicePrint_PrepareVerify(void* handle, void* param);

// 本函数完成当前音频的声纹认证, 如果运行状态正常，res_role为算法库约定的6个角色之一
uvp_status Dueruvoice_VoicePrint_Verify(void* handle, short* audio_buf, int buf_len, uvp_roles* res_role);

// 本函数设定验证时的阈值，推荐0.5（缺省设置），0-1内可调, 越大越不容易通过验证
void Dueruvoice_VoicePrint_SetVerifyThres(void* handle, uvp_roles role, float thres);

void Dueruvoice_VoicePrint_Uninit(void* handle);

// 下面的是授权相关，目前暂时只做约定

/*
 * 用户需要实现的回调函数，用来把https_post_body通过HTTPS协议，POST到UVoice的授权服务器
 * 服务器的返回数据，需要通过此函数return回来。
 * 当下的服务器地址为：
 * https://srv01.51asr.com:8007/asrsn_active2"
 * 因此，这个回调函数的行为应该和以下curl命令等效：
 * curl -k -s --data-binary $https_post_body https://srv01.51asr.com:8007/asrsn_active2"
 */
typedef const char* (*duer_uvoice_auth_callback_t)(const char* https_post_body);

/*--------------------------------------------------------------------------------------*/
/*
 * 结构体说明如下：
 * license: UVoice发布的授权码
 * license_path:此参数在activate_type=0的时候表示服务器授权设备成功后，授权信息写入的文件。
 *              如果activate_type=1,用flash信息进行授权，此时，这个参数表示flash对应的设备文件。
 * uuid：设备的唯一码
 * activate_type:记录授权信息的类型，0：表示以文件方式记录，1：flash,2：efuse
 * auth_cb:用户需要实现的回调函数，参考上边函数指针的说明
 */
typedef struct uv_activate_param {
        char *license;
        char *license_path;
        char *uuid;
        int  activate_type;
        duer_uvoice_auth_callback_t auth_cb;
} uv_activate_param;

#endif
