#ifndef __UVOICE_H__
#define __UVOICE_H__

#ifdef __cplusplus
extern "C" {
#endif

#define UVOICE_ERROR_PARAMETER -4
#define UVOICE_ERROR_NULLPTR   -3
#define UVOICE_ERROR_GENER     -2
#define UVOICE_ERROR_UNINIT    -1
#define UVOICE_NORMAL           0


typedef enum uvoice_pramterId_e {
	enable_agc,
} uvoice_paramterId; 

typedef void (*audioOut)(void *handle, short *buf, int len, int vad_status, void *usrdata);
typedef void (*kwscallback)(void *handle, int id, float confidence, void *usrdata);
typedef void (*kwsAudiocallback)(void* handle, short* kws_audio_buf,int len,float confidence,float thres, void* userdata);
typedef void (*cmdcallback)(void *handle, int id, float confidence, void *usrdata);
typedef void (*errorcallback)(void *handle, int errorcode, void *usrdata);
typedef void (*vadcallback)(void *handle, int id, void *usrdata);
typedef int (*logPrintFunc)(const char *format, ...);

struct callback_function {
	audioOut copydata_cb;
	kwscallback kws_cb;
	cmdcallback cmd_cb;
	errorcallback error_cb;
	vadcallback vad_cb;
        kwsAudiocallback kws_audio_cb;
};

#define MAX_MICIN_NUM 8
#define MAX_REFIN_NUM 2

struct audio_buf {
    short *audioin[MAX_MICIN_NUM];
    short *audioref[MAX_REFIN_NUM];
};

// get SDK version
char *UVoice_HomeSpeech_GetVersion();

// re-direct SDK log info to log_print_func
void UVoice_HomeSpeech_SetLogFun(logPrintFunc fun);

// init homespeech SDK handle
void *UVoice_HomeSpeech_Init(void* param);

// input audio stream to SDK 
void UVoice_HomeSpeech_Process(void *handle, void *audio, int len);

// get doa angle info 2mics return [0.0-180.0]
float UVoice_HomeSpeech_GetDOAInfo(void *handle);

// callback function setting
void UVoice_HomeSpeech_SetCallback(void *handle, void *cb);

// clear SDK memory
void UVoice_HomeSpeech_Fini(void *handle);

// set callback function user data
void UVoice_HomeSpeech_SetUserData(void *handle, void *usrdata);

// SDK configure setting, to enable VAD, etc. 
void UVoice_HomeSpeech_Ctrl(void *handle, uvoice_paramterId id, void *value);

#ifdef __cplusplus
}
#endif

#endif