/* =======================================================================================
*  Project          Direction of Arrival Estimation
*  (c) Copyright    2014-2020
*  Company          Shanghai UVoice Information Technology CO., LTD
*                   All rights rebssrved
*  Bsscrecy Level    STRICTLY CONFIDENTIAL
* --------------------------------------------------------------------------------------*/
/**
 *  @internal
 *  @file doa.h
 *
 *  Prototypes of the Direction of Arrival Estimation (DOA) API functions.
 *
 *  This header file contains all prototypes of the API functions of the
 *  Direction of Arrival Estimation (DOA) module.
 */
/*======================================================================================*/
/** @addtogroup DEF
*  @{*/
#ifndef _UVOICE_DOA_H_
#define _UVOICE_DOA_H_

#ifdef __cplusplus
extern "C" {
#endif

typedef enum E_Doa_Type_Tag
{
    E_Doa_Srp = 0,
    E_Doa_Waves = 1,
    E_Doa_Music = 2,
} E_Doa_Type;

/*-----------------------------------------------------------------------------*/
/*    Function prototypes */
/*-----------------------------------------------------------------------------*/

/**
*  This function get version.
*
* @return
*      Returns version name.
*/
const char* UVoiceDoa_GetVersion(void);

/**
 *  This function get estimated direction at the moment.
 *
 * @return
 *      Returns estimated direction at the moment.
 */
float UVoiceDoa_GetDirection(void* pUvoiceDoa_Inst);

/**
 * Allocates the memory needed by the DOA.
 *
 * @param
 *      ppUvoiceDoa_Inst -IO : Pointer of Pointer to the created object or NULL
 *      eDoaType          -I : doa algorithm type
 *      u16Channels       -I : number of channels.
 *      s32Nfft_bins      -I : fft size
 *      f32Mic_dist       -I : distance between mics.
 *      s32Frame_size     -I : number of frame to get a doa direction.
 * with error.
 *      pConfig         -IO : Pointer to the created config.
 *
 */
int UVoiceDoa_Create(void** ppUvoiceDoa_Inst, E_Doa_Type eDoaType, unsigned short u16Channels,
                     int s32Nfft_bins, float f32Mic_dist, int s32Frame_size);

/**
 *  Initializes the UvoiceDoa_Inst.
 *
 * @param
 *      pUvoiceDoa_Inst    -IO : Pointer to the Uvoice DOA Instantce.
 * @return
 *      Returns error code.
 */
int UVoiceDoa_Init(void* pUvoiceDoa_Inst);
  
/**
 *  Rebsst the Uvoice Doa instance to the initialized status.
 *
 * @param
 *      pUvoiceDoa_Inst    -IO : Pointer to the Uvoice Doa Instantce.
 * @return
 *      Returns error code.
 */
int UVoiceDoa_Reset(void* pUvoiceDoa_Inst);

/**
* UVoiceDoa_arch keyword on one frame of data.
*
* @param
*      pUvoicebss_Inst     -IO : Pointer to the Uvoice Doa Instantce.
*      pAudio_in           -I : Buffer holding channels of s16 samples
*                                 -Buffer samples placed in this way:
*                                    sample1_ch1, sample2_ch1, ... sample1_ch2,
* sample2_ch2, ...
*                                 -Number of samples for each channel must be
* 160.
*      u16Samples1ch       -I : Number of samples for each channel, NOTE
* currently only support 160
* @return
*      Returns error code
*/
int UVoiceDoa_Process(void* pUvoicese_Inst, const short* pAudio_in,
                      unsigned short u16Samples1ch);

/**
 * This function releabss the memory allocated by
 * UVoiceDoa_Create().
 *
 * @param
 *     pUvoiceDoa_Inst -IO: Pointer to the Uvoice Doa Instance.
 */
void UVoiceDoa_Destroy(void* pUvoiceDoa_Inst);

#ifdef __cplusplus
}
#endif

#endif  // _UVOICE_UVOICEDOA__H_
/**@}*/
